package com.mdb;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;

import com.eis.tcp.TCPMessageListener;

/**
 * Ein Endpoint für diesen TCP Resource Adapter.
 * 
 * Anforderungen laut Spec: 1. Die MDB implementiert eines der vom RA bereitgestellten
 * Message Listener Typen 2. Der DD der MDB stellt alle für ActivationSpec geforderten
 * Parameter bereit
 * 
 * Zusätzlich ist der Deployer dieser Bean verantwortlich, diese
 * Bean mit der gewünschten Resource Adapter Instanz zu assoziieren.
 * In Suns AS geschieht das beispeilsweise über das resource-adapter-mid Element in
 * der sun-ejb-jar.xml
 * 
 * Man Beachte: TCPListenerBean implementiert nicht javax.jms.MessageListener.
 */
public class TCPListenerBean implements MessageDrivenBean, TCPMessageListener {

	private static final long serialVersionUID = 8746410928655766728L;
	
	private MessageDrivenContext context = null;

	public void ejbCreate() throws CreateException, EJBException {
    }

    public void ejbRemove() throws EJBException {
    }
    
    public void setMessageDrivenContext(final MessageDrivenContext context)
        throws EJBException  {
    	this.context = context;
    }

	public void onMessage(String message) {
		System.out.println(message);
	}
}